<?php

namespace frontend\models;

use Yii;
use yii\base\Model;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\FileHelper;

class Attachments extends Model
{
    public function SaveTempAttachments($attachments)
    {
        $file=[];
        $allwoedFiles=['exe', 'dll', 'pws', 'bat'];

        if (!empty($attachments)) {
            if (count($attachments['file']['name']) > 0) {
                //Loop through each file
                for ($i = 0; $i < count($attachments['file']['name']); $i++) {
                    //Get the temp file path
                    $tmpFilePath = $attachments['file']['tmp_name'][$i];
                    //Make sure we have a filepath
                    if ($tmpFilePath != "") {
                        //save the filename
                        $shortname = $attachments['file']['name'][$i];
                        $size = $attachments['file']['size'][$i];
                        $ext = substr(strrchr($shortname, '.'), 1);
                        if(in_array($ext,$allwoedFiles)){
                            //save the url and the file
                            $fpath = Yii::getAlias('@absPath').'/filesStorage/'.Yii::$app->user->identity->id.'/';
                            $randomFileName = Yii::$app->security->generateRandomString(40) . "." . $ext;
                            $newFileName = $fpath.$randomFileName;

                            $baseFileName = '/filesStorage/'.Yii::$app->user->identity->id.'/'.$randomFileName;
                            
                            FileHelper::createDirectory(Yii::getAlias('@absPath').'/filesStorage/'.Yii::$app->user->identity->id);
                
                            if (move_uploaded_file($tmpFilePath, $newFileName)) {
                                if($ext=='bat' || $ext=='pws'){
                                    $file[] =['fileName'=>$baseFileName,'type'=>$ext,'size'=>$size,'originalName'=>$shortname, 'fileContent' => file_get_contents($newFileName)];
                                }else{
                                    $file[] =['fileName'=>$baseFileName,'type'=>$ext,'size'=>$size,'originalName'=>$shortname];
                                }
                            }
                        }
                    }
                }
                //print_r($file);die();
            }

        }
        return $file;
    }
}